### Name: wle.normal.multi
### Title: Robust Estimation in the Normal Multivariate Model
### Aliases: wle.normal.multi
### Keywords: models multivariate robust

### ** Examples

library(wle)

data(iris)

smooth <- wle.smooth(dimension=4,costant=4,
                    weight=0.5,interval=c(0.3,0.7))

x.data <- as.matrix(iris[iris[,5]=="virginica",1:4])

result <- wle.normal.multi(x.data,boot=20,group=21,
                           num.sol=3,smooth=smooth$root)

result

result <- wle.normal.multi(x.data,boot=20,group=21,
                           num.sol=1,smooth=smooth$root)

barplot(result$weights,col=2,xlab="Observations",
       ylab="Weights",ylim=c(0,1),
       names.arg=seq(1:length(result$weights)))



