### Name: wle.t.test
### Title: Weighted Likelihood Student's t-Test
### Aliases: wle.t.test print.wle.t.test
### Keywords: robust htest

### ** Examples

library(wle)

set.seed(1234)

x <- rnorm(20,0,1)
y <- rnorm(20,6,1)

t.test(x,y)                # P < 2.2e-16
wle.t.test(x,y,group=5)    # P < 2.2e-16

t.test(x,y=c(y,250))       # P = 0.1419 -- NOT significant anymore
wle.t.test(x,y=c(y,250),group=5) # P < 2.2e-16 -- still significant 
set.seed(1234)

# three roots for 'x' and three roots for 'y'
# with nine t-test value
res <- wle.t.test(x=c(rnorm(40,0,1),rnorm(40,10,1)),
           y=c(rnorm(40,0,1),rnorm(40,10,1)),
           group=4,num.sol=3,boot=100)

print(res) # print ALL the t-test
print(res,x.root=1,y.root=1)   # print the test associated to the 
                               # x.root=1,y.root=1 

root.1.1 <- res$test[[1]][[1]] # access to the object associated 
                               # to the x.root=1,y.root=1 

names(root.1.1)

set.seed(1234)

# one root and NOT significant t-test
wle.t.test(x=c(rnorm(40,0,1),rnorm(40,10,1)),
           y=c(rnorm(40,0,1),rnorm(40,10,1)),
           group=4,num.sol=3,boot=100,paired=TRUE)




