### Name: wle.var.test
### Title: Weighted F Test to Compare Two Variances
### Aliases: wle.var.test
### Keywords: robust htest

### ** Examples


set.seed(2345)

x <- rnorm(50,0,1)
y <- rnorm(50,10,1)

res.x <- wle.normal(x,group=5)
res.y <- wle.normal(y,group=5)

wle.var.test(res.x, res.y) # Do x and y have the same variance?

set.seed(2345)

x <- c(rnorm(50,0,1),rnorm(20,10,1))
y <- c(rnorm(50,10,1),rnorm(10,0,5))

res.x <- wle.normal(x,group=5,num.sol=2)
res.y <- wle.normal(y,group=5)

res.x
wle.var.test(res.x, res.y, x.root=1)
if (res.x$tot.sol>1) wle.var.test(res.x, res.y, x.root=2)



