### Name: FScomputeEnvelope
### Title: Compute a Confidence Envelope
### Aliases: FScomputeEnvelope
### Keywords: multivariate

### ** Examples

X <- matrix(rnorm(1200), nrow = 200, ncol = 6)
temp <- fwdmvRandomStart(X)

# the envelope is computed by FScomputeEnvelope #
plot(temp, envelope = FALSE)
envelope <- FScomputeEnvelope(200, 6, 12)
domain <- as.numeric(row.names(envelope))
correction <- 200*6*(domain-2)/((200-1)*(domain-6-1))
envelope <- sqrt(sweep(envelope, 1, correction, "*"))
matlines(domain, envelope, lty = 2, col = 1)



