### Name: pboot
### Title: Parallel Bootstrap
### Aliases: pboot
### Keywords: misc utilities optimize manip data

### ** Examples

#These examples assume a master called my.server.edu running on port 39000 and a client 
#1.2.3.4 using return port 40000. This can be configured by running the single machine
#example at the bottom of user function biopara.
#The examples are copied from the standard function boot and shown run through biopara in parallel.

#We need to load the boot library to get the datasets. This will need to be done for the workers
library(boot)

data(city);
ratio <- function(d, w) sum(d$x * w)/sum(d$u * w)
## Not run: out<-biopara(list("localhost",39000),list("localhost",40000),1,list("setenv"))
#Since we are using a data set directly, we will need to query the number of servers and send
#that many runs library and data
## Not run: out<-biopara(list("localhost",39000),list("localhost",40000),1,list("numservers"))
## Not run: out<-biopara(list("localhost",39000),list("localhost",40000),out,list("library(boot);data(city)"))
#Finally a call to pboot
## Not run: out<-pboot(list("localhost",39000),list("localhost",40000),5,city, ratio, R=999, stype="w")

#We do not have to call biopara on data here since the data set becomes a user defined object
data(gravity)
diff.means <- function(d, f)
{    n <- nrow(d)
     gp1 <- 1:table(as.numeric(d$series))[1]
     m1 <- sum(d[gp1,1] * f[gp1])/sum(f[gp1])
     m2 <- sum(d[-gp1,1] * f[-gp1])/sum(f[-gp1])
     ss1 <- sum(d[gp1,1]^2 * f[gp1]) - 
            (m1 *  m1 * sum(f[gp1]))
     ss2 <- sum(d[-gp1,1]^2 * f[-gp1]) - 
            (m2 *  m2 * sum(f[-gp1]))
     c(m1-m2, (ss1+ss2)/(sum(f)-2))
}
grav1 <- gravity[as.numeric(gravity[,2])>=7,]
## Not run: out<-biopara(list("localhost",39000),list("localhost",40000),1,list("setenv"))
## Not run: out<-pboot(list("localhost",39000),list("localhost",40000),5,grav1, diff.means, R=999, stype="f", strata=grav1[,2])

data(nuclear)
nuke <- nuclear[,c(1,2,5,7,8,10,11)]
nuke.lm <- glm(log(cost)~date+log(cap)+ne+ ct+log(cum.n)+pt, data=nuke)
nuke.diag <- glm.diag(nuke.lm)
nuke.res <- nuke.diag$res*nuke.diag$sd
nuke.res <- nuke.res-mean(nuke.res)
nuke.data <- data.frame(nuke,resid=nuke.res,fit=fitted(nuke.lm))
new.data <- data.frame(cost=1, date=73.00, cap=886, ne=0, ct=0, cum.n=11, pt=1)
new.fit <- predict(nuke.lm, new.data)
nuke.fun <- function(dat, inds, i.pred, fit.pred, x.pred)
{
     assign(".inds", inds, envir=.GlobalEnv)
     lm.b <- glm(fit+resid[.inds] ~date+log(cap)+ne+ct+
          log(cum.n)+pt, data=dat)
     pred.b <- predict(lm.b,x.pred)
     remove(".inds", envir=.GlobalEnv)
     c(coef(lm.b), pred.b-(fit.pred+dat$resid[i.pred]))
}
## Not run: out<-biopara(list("localhost",39000),list("localhost",40000),1,list("setenv"))
## Not run: nuke.boot<-pboot(list("localhost",39000),list("localhost",40000),5,nuke.data, nuke.fun, R=999, m=1, fit.pred=new.fit, x.pred=new.data)
#The bootstrap prediction error for the first bootstrap
## Not run: mean(nuke.boot[[1]][[2]][,8]^2)
#Basic bootstrap prediction limits on first bootstrap
## Not run: new.fit-sort(nuke.boot[[1]][[2]][,8]^2)[c(975,25)]




