### Name: ex2.sim
### Title: Bivpois Example 2 Dataset: Simulated Data
### Aliases: ex2.sim
### Keywords: datasets models regression

### ** Examples

#  Models of example 2 can be fitted using the command
#  demo(ex2, package='bivpois')
#
#  Here we present the same commands but iterations of the EM were restricted to 2 to save time

library(bivpois) # load bivpois library
data(ex2.sim)    # load ex2.sim data from bivpois library
#
# Model 1: BivPois
ex2.m1<-lm.bp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim, maxit=2 )
# Model 2: Zero Inflated BivPois 
ex2.m2<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=0, maxit=2 )
# Model 3: Diagonal Inflated BivPois with DISCRETE(1) diagonal  distribution
ex2.m3<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=1, maxit=2 )
# Model 4: Diagonal Inflated BivPois with DISCRETE(2) diagonal  distribution
ex2.m4<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=2, maxit=2 )
# Model 5: Diagonal Inflated BivPois with DISCRETE(3) diagonal  distribution
ex2.m5<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=3, maxit=2 )
# Model 6: Diagonal Inflated BivPois with DISCRETE(4) diagonal  distribution
ex2.m6<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=4, maxit=2 )
# Model 7: Diagonal Inflated BivPois with DISCRETE(5) diagonal  distribution
ex2.m7<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=5, maxit=2 )
# Model 8: Diagonal Inflated BivPois with DISCRETE(6) diagonal  distribution
ex2.m8<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , jmax=6, maxit=2 )
# Model 9: Diagonal Inflated BivPois with POISSON diagonal distribution
ex2.m9<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , 
                 distribution="poisson", maxit=2 )
# Model 10: Diagonal Inflated BivPois with GEOMETRIC diagonal distribution
ex2.m10<-lm.dibp( x~z1 , y~z1+z5, l1l2=~z3, l3=~.-z5, data=ex2.sim , 
                  distribution="geometric", maxit=2 )
#
# printing parameters of model 7
ex2.m7$beta1
ex2.m7$beta2
ex2.m7$beta3
ex2.m7$p
ex2.m7$theta
#
# printing parameters of model 9
ex2.m9$beta1
ex2.m9$beta2
ex2.m9$beta3
ex2.m9$p
ex2.m9$theta



