### Name: cdt
### Title: Centered default transform
### Aliases: cdt cdt.default cdt.acomp cdt.rcomp cdt.aplus cdt.rplus
###   cdt.rmult cdt.factor cdt.inv cdt.inv.default cdt.inv.acomp
###   cdt.inv.rcomp cdt.inv.aplus cdt.inv.rplus cdt.inv.rmult
### Keywords: multivariate

### ** Examples

## Not run: 
##D # the cdt is defined by
##D cdt         <- function(x) UseMethod("cdt",x)
##D cdt.default <- function(x) x
##D cdt.acomp   <- clr 
##D cdt.rcomp   <- cpt 
##D cdt.aplus   <- ilt 
##D cdt.rplus   <- iit 
## End(Not run)
x <- acomp(1:5)
(ds <- cdt(x))
cdt.inv(ds,x)
(ds <- cdt(rcomp(1:5)))
cdt.inv(ds,rcomp(x))
  data(Hydrochem)
  x = Hydrochem[,c("Na","K","Mg","Ca")]
  y = acomp(x)
  z = cdt(y)
  y2 = cdt.inv(z,y)
  par(mfrow=c(2,2))
  for(i in 1:4){plot(y[,i],y2[,i])}




