### Name: cbpp
### Title: Serological Incidence of Contagious Bovine Pleuropneumonia in
###   Ethiopia
### Aliases: cbpp
### Keywords: datasets

### ** Examples

## response as a matrix
(m1 <- lmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
            family = binomial, data = cbpp))

## response as a vector of probabilities and usage of argument "weights"
m2 <- lmer(incidence / size ~ period + (1 | herd), weights = size,
           family = binomial, data = cbpp)

## Confirm that these are equivalent:
stopifnot(all.equal(coef(m1), coef(m2)),
          all.equal(ranef(m1), ranef(m2)))



