### Name: lmer-class
### Title: Mixed Model Representations and *mer Methods
### Aliases: lmer-class glmer-class mer-class mer2-class lmer2-class
###   coef.lmer-class summary.mer-class summary.mer2-class
###   summary.lmer-class summary.lmer2-class summary.glmer-class
###   ranef.lmer-class anova,mer-method anova,mer2-method coef,mer-method
###   coef,mer-method coerce,lmer,dsTMatrix-method
###   coerce,mer,dtCMatrix-method coerce,mer,pMatrix-method
###   chol,lmer,ANY-method confint,mer-method deviance,mer-method
###   deviance,mer2-method fitted,mer-method formula,mer-method
###   logLik,mer-method logLik,mer2-method plot,coef.lmer-method
###   plot,ranef.lmer-method print,mer-method print,mer2-method
###   qqmath,ranef.lmer-method resid,glmer-method resid,lmer-method
###   residuals,glmer-method residuals,lmer-method show,mer-method
###   show,mer2-method simulate,mer-method summary,mer-method
###   summary,mer2-method terms,lmer-method update,mer-method
###   vcov,mer-method vcov,mer2-method with,lmer-method
###   deviance,summary.mer-method deviance,summary.mer2-method
###   logLik,summary.mer-method logLik,summary.mer2-method
###   vcov,summary.mer-method vcov,summary.mer2-method
###   summary,summary.mer-method summary,summary.mer2-method
### Keywords: classes

### ** Examples

(fm2 <- lmer(Reaction ~ Days + (1|Subject) + (0+Days|Subject),
             data = sleepstudy))
print(fm2, digits = 10, corr = FALSE) # more precision; no corr.matrix

logLik(fm2)
(V2 <- vcov(fm2))
str(resid(fm2))

## Simulate 'Reaction' according to the fitted model:
dim(ss <- simulate(fm2, nsim = 200, seed = 101)) ## -> 180 x 200



