### Name: mcmcsamp
### Title: Generate an MCMC sample
### Aliases: mcmcsamp mcmcsamp,lmer-method mcmcsamp,glmer-method
### Keywords: methods datagen

### ** Examples

(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
set.seed(101); samp0 <- mcmcsamp(fm1, n = 1000) # default deviance = FALSE
set.seed(101); samp1 <- mcmcsamp(fm1, n = 1000, deviance = TRUE)
colnames(samp1) # has "deviance"
if (require("coda", quietly = TRUE, character.only = TRUE)) {
    densityplot(samp1)
    qqmath(samp1)
    xyplot(samp1, scales = list(x = list(axs = 'i')))
    print(summary(samp1))
    print(autocorr.diag(samp1))
}
## potentially useful approximate D.F. :
(eDF <- mean(samp1[,"deviance"]) - deviance(fm1, REML=FALSE))
## Don't show: 
stopifnot(abs(eDF - 7) < 1,
          all.equal(samp0, samp1[,1:6], tol=0))
## End Don't show



