check.fs               package:lmomco               R Documentation

_C_h_e_c_k _V_e_c_t_o_r _o_f _N_o_n_e_x_c_e_e_d_a_n_c_e _P_r_o_b_a_b_i_l_i_t_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function checks that a nonexceedance probability (F) is in
     the 0 <= F <= 1 range. It does not check that the distribution
     whether the function as specified by current parameters if valid
     for F = 0 or F = 1. End point checking  is left to additional
     internal checks within the functions implementing the
     distribution. The function is intended for internal use within
     this library to build logic flow throughout the distribution
     functions. Users are not expected to need this function
     themselves. The 'check.fs' function is separate because  of the
     heavy use of the logic across a myriad of functions in this
     package.

_U_s_a_g_e:

     check.fs(fs)

_A_r_g_u_m_e_n_t_s:

      fs: A vector of nonexceedance probablity values.

_V_a_l_u_e:

    TRUE: The nonexceedance probabilities are valid.

   FALSE: The nonexceedance probabilities are invalid.

_A_u_t_h_o_r(_s):

     W.H. Asquith

_S_e_e _A_l_s_o:

     'quacau', 'quaexp',  'quagam',  'quagev', 'quagld',   'quaglo', 
      'quagno',  'quagpa', 'quagum',  'quakap',  'quanor',  'quape3', 
      'quawak', and 'quawei'

_E_x_a_m_p_l_e_s:

     F <- c(0.5,0.7,0.9,1.1)
     if(check.fs(F) == FALSE) cat("Bad nonexceedances 0<F<1\n")

