pwm.pp                package:lmomco                R Documentation

_P_l_o_t_t_i_n_g-_P_o_s_i_t_i_o_n _S_a_m_p_l_e _P_r_o_b_a_b_i_l_i_t_y-_W_e_i_g_h_t_e_d _M_o_m_e_n_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     The sample Probability-Weighted Moments (PWMs) are computed from
     the plotting positions of the data. The first five beta_r's are
     computed. The plotting-position formula is


                     p_i = frac{i+A}{n+B} mbox{,}


     where pp_i is the nonexceedance probability F of the ith ascending
     data values. The parameters A and B together specify the
     plotting-position type, and n is the sample size. The PWMs are
     computed by


       beta_r = n^{-1}sum_{i=1}^{n}p_i^r times x_{j:n} mbox{,}


     where x_{j:n} is the jth order statistic x_{1:n} <= x_{2:n} <=
     x_{j:n} ... <= x_{n:n} of random variable X, and r is 0, 1, 2,
     ....

_U_s_a_g_e:

     pwm.pp(x,A,B)

_A_r_g_u_m_e_n_t_s:

       x: A vector of data values.

       A: A value for the plotting-position formula.

       B: Another value for the plotting-position formula.

_V_a_l_u_e:

     An R 'list' is returned.

   BETA0: The first PWM-equal to the arithmetic mean.

   BETA1: The second PWM.

   BETA2: The third PWM.

   BETA3: The fourth PWM.

   BETA4: The fifth PWM.

_A_u_t_h_o_r(_s):

     W.H. Asquith

_R_e_f_e_r_e_n_c_e_s:

     Greenwood, J.A., Landwehr, J.M., Matalas, N.C., and Wallis, J.R.,
     1979, Probability weighted moments-Definition and relation to
     parameters of several distributions expressable in inverse form:
     Water Resources Research, vol. 15, p. 1,049-1,054.

     Hosking, J.R.M., 1990, L-moments-Analysis and estimation of
     distributions using linear combinations of order statistics:
     Journal of the Royal Statistical Society, Series B, vol. 52, p.
     105-124.

     Hosking, J.R.M., 1996, FORTRAN routines for use with the method of
     L-moments: Version 3, IBM Research Report RC20525, T.J. Watson
     Research Center, Yorktown Heights, New York.

     Hosking, J.R.M. and Wallis, J.R., 1997, Regional frequency
     analysis-An approach based on L-moments: Cambridge University
     Press.

_S_e_e _A_l_s_o:

     'pwm.ub', 'pwm.gev', 'pwm2lmom'

_E_x_a_m_p_l_e_s:

     pwm <- pwm.pp(rnorm(20),A=-0.35,B=0)

