### Name: dist.list
### Title: List of Distribution Names
### Aliases: dist.list
### Keywords: distribution

### ** Examples

# Build an L-moment object
LM <- vec2lmom(c(1000,1500,0.3,0.1,0.04))
lm2 <- lmorph(LM)  # convert to vectored format
lm1 <- lmorph(lm2) # and back to named format

dist <- dist.list()

# demonstrate that lmom2par internally converts
# to needed L-moment object
for(i in seq(1,length(dist))) {
  # skip Cauchy (needs TL-moments) and GLD (speed)
  if(dist[i] == 'cau' || dist[i] == 'gld') next
  print(lmom2par(lm1,type=dist[i]))
  print(lmom2par(lm2,type=dist[i]))
}




