### Name: genci
### Title: Generate Confidence Intervals for Quantiles of a Parent
###   Distribution
### Aliases: genci
### Keywords: distribution

### ** Examples

  # For all these examples, nsim is way too small.
  MEAN  <- 0    # mean of zero
  SIGMA <- 100  # standard deviation of 100
  PAR   <- vec2par(c(MEAN,SIGMA),type='nor') # make parameter object
  F     <- nonexceeds() # list of useful nonexceedance probabilities
  # nsim is small for speed of example not accuracy.
  CI    <- genci(PAR,n=10,F=F,nsim=20)
  plot(CI$nonexceed_prob,CI$true,type='l',lwd=2)
  lines(CI$nonexceed_prob,CI$lower,col=2)
  lines(CI$nonexceed_prob,CI$upper,col=3)
  
  # The qnorm call has been added to produce "normal probability"
  # paper on the horizonal axis. The parent is heavy-tailed.
  GEV <- vec2par(c(3000,1500,-.3),type='gev') # a GEV distribution
  # use 15 simulations of size 20 samples
  # The generalized normal distribution is a general case of lognormal---
  # for illustration, suppose the parent GEV is modeling phenomena that
  # are strictly positive. So to prevent negative lower limits, use the 
  # lognormal distribution as the error model.
  CI  <- genci(GEV,n=20,nsim=15,edist='gno')
  ymin <- log10(min(CI$lower))
  ymax <- log10(max(CI$upper))
  plot(qnorm(CI$nonexceed_prob),log10(CI$true),type='l',ylim=c(ymin,ymax),lwd=2)
  lines(qnorm(CI$nonexceed_prob),log10(CI$lower),col=2)
  lines(qnorm(CI$nonexceed_prob),log10(CI$upper),col=3)



