### Name: qua2ci
### Title: Estimate Confidence Interval for a Single Quantile of a Parent
###   Distribution
### Aliases: qua2ci
### Keywords: distribution

### ** Examples

  # It is well known that standard deviation (sigma) of the
  # sample mean is equal to sigma/sample_size.
  MEAN  <- 0
  SIGMA <- 100
  PAR   <- vec2par(c(MEAN,SIGMA),type='nor')
  CI    <- qua2ci(0.5,PAR,n=10,nsim=20) # F=0.5-->median=mean
  # Theoretrical sample mean sigma = 100/10 = 10
  # L-moment theory: L-scale*sqrt(pi) = sigma
  # Thus, it follows that
  CI$elmoms$lambdas[2]/sqrt(pi)
  # approaches 10 as nsim --> Inf.

  # Another example.
  D   <- c(123,34,4,654,37,78, 93, 95, 120) # fake sample
  lmr <- lmoms(D)    # compute the lmoments of the data
  WEI <- parwei(lmr) # estimate parameters of the weibull
  CI  <- qua2ci(0.75,WEI,20,nsim=20,ci=0.95)
  # CI contains the estimate 95-percent 
  # confidence interval for the 75th-percent of the parent
  # weibull distribution for size 20 samples from the parent



