### Name: as.sealevel
### Title: Coerce data into sea-level dataset
### Aliases: as.sealevel
### Keywords: misc

### ** Examples

library(oce)
h <- 1:(24*100) # fake 100 days
eta <- 1.0 * sin(2*pi*h/12.4172) + 0.8 * sin(2*pi*h/24.0)
eta <- eta + 0.1 * rnorm(length(h)) # add some noise
h <- as.sealevel(eta, units="m")
summary(h)



