### Name: plot.TS
### Title: Plot temperature-salinity diagram for seawater (CTD) data
### Aliases: plot.TS
### Keywords: misc

### ** Examples

## Not run: 
##D library(oce)
##D profile <- read.ctd("/usr/local/lib/R/library/oce/demo/ctdprofile.cnv")
##D attach(profile)
##D plot.TS(profile)
##D # North Atlantic thermocline water, mixing to Antarctic Intermediate Water
##D # (after Defant's analysis)
##D N <- 10
##D Srange <- c(34.15, 35.94)
##D Trange <- c(3.3,18)
##D SS <- Srange[1] + (Srange[2] - Srange[1]) *(1:N)/(N-1) + 0.01*rnorm(N)
##D TT <- Trange[1] + (Trange[2] - Trange[1]) *(1:N)/(N-1) + 0.01*rnorm(N)
##D plot.TS(as.CTD(S=SS, T=TT, p=0),type='b',pch=19)
## End(Not run)



