### Name: sw.N2
### Title: Seawater square of buoyancy frequency
### Aliases: sw.N2
### Keywords: misc

### ** Examples

library(oce)
data(ctd)
p <- ctd$data$pressure
sigthe <- sw.sigma.theta(ctd$data$temperature, ctd$data$salinity, ctd$data$pressure)
par(mfcol=c(3,1))
plot(sigthe, -p)
lines(sigthe, -p)
plot(sw.N2(p,sigthe), -p)
lines(sw.N2(p,sigthe), -p)
abline(v=0)
# Demonstrate the effect of the df parameter in smooth.spline()
lines(sw.N2(p,sigthe,df=length(p)/4), -p)
abline(v=0)



