### Name: sw.theta
### Title: Seawater potential temperature
### Aliases: sw.theta
### Keywords: misc

### ** Examples

library(oce)
print(sw.theta(35, 13, 1000)) # 12.858

print(sw.theta(40,40,10000,0,"UNESCO1983")) # 36.89073 (Fofonoff et al., 1983)
        
# Demonstrate that the methods agree to a couple of
# millidegrees over a typical span of values
S <- c(30,30,38,38)
T <- c(-2,-2,30,30)
p <- rep(1000,4)                                   
print(max(abs(sw.theta(S,T,p) - sw.theta(S,T,p,0,"UNESCO1983"))))



