plot.TS                 package:oce                 R Documentation

_P_l_o_t _t_e_m_p_e_r_a_t_u_r_e-_s_a_l_i_n_i_t_y _d_i_a_g_r_a_m _f_o_r _s_e_a_w_a_t_e_r (_C_T_D) _d_a_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Plot temperature-salinity diagram for seawater (CTD) data.

_U_s_a_g_e:

     plot.TS(x, rho.levels = 5, grid = FALSE,
             col.data="black", col.rho="blue",  col.grid = "lightgray",
             debug=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

       x: A 'cdt' object, e.g. as read by 'read.ctd'.

rho.levels: Either a list of density levels for which to draw 
          isopycnal lines, or a suggestion for the number of levels. In
          the latter case, an attempt is made to draw this number of
          levels, with "clean" isopycnal values (in which the  contour
          increment is a multiple of 1, 2, or 5), but often a clean
          interval demands more isopycnal contours than requested;
          also, small adjustments to the 'rho.levels' value often have
          little affect on the number of contours.

    grid: Set 'TRUE' to get a grid.

col.data: Color for data.

 col.rho: Color for isopycnal lines.

col.grid: Color of grid.

   debug: Flag to turn on debugging mode (prints info on isopycnal
          choices)

     ...: optional arguments passed to plotting functions.

_D_e_t_a_i_l_s:

     Creates a temperature-salinity plot for a CTD cast.

_V_a_l_u_e:

     None.

_A_u_t_h_o_r(_s):

     Dan Kelley Dan.Kelley@Dal.Ca

_R_e_f_e_r_e_n_c_e_s:

_S_e_e _A_l_s_o:

     'summary.ctd' summarizes the information, while 'read.ctd' scans
     it from a file.

_E_x_a_m_p_l_e_s:

     ## Not run: 
     library(oce)
     profile <- read.ctd("/usr/local/lib/R/library/oce/demo/ctdprofile.cnv")
     attach(profile)
     plot.TS(profile)
     # North Atlantic thermocline water, mixing to Antarctic Intermediate Water
     # (after Defant's analysis)
     N <- 10
     Srange <- c(34.15, 35.94)
     Trange <- c(3.3,18)
     SS <- Srange[1] + (Srange[2] - Srange[1]) *(1:N)/(N-1) + 0.01*rnorm(N)
     TT <- Trange[1] + (Trange[2] - Trange[1]) *(1:N)/(N-1) + 0.01*rnorm(N)
     plot.TS(as.CTD(S=SS, T=TT, p=0),type='b',pch=19)
     ## End(Not run)

