plot.profile               package:oce               R Documentation

_P_l_o_t _a _C_T_D _p_r_o_f_i_l_e _o_f _v_a_r_i_o_u_s _q_u_a_n_t_i_t_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plot a CTD profile, in any of several common formats.

_U_s_a_g_e:

     plot.profile(x, type="S", 
     col.S="darkgreen", col.t="red",
     col.rho="blue", col.N2="brown",
     grid=FALSE, col.grid="lightgray",
     ...)

_A_r_g_u_m_e_n_t_s:

       x: A 'cdt' object, e.g. as read by 'read.ctd'.

    type: Type of profile to plot, from the list below.

        '_S' Profile of salinity.

        '_T' Profile of _in-situ_ temperature.

        '_s_i_g_m_a_t_h_e_t_a' Profile of density (expressed as sigma_theta).

        '_S+_T' Profile of salinity and temperature within a single axis
             frame.

        '_N_2' Profile of square of buoyancy frequency N^2, calculated
             with 'sw.N2' with an optional argument setting of
             'df=length(x$p)/4' to do  some smoothing.

        '_r_h_o+_N_2' Profile of density and the square of buoyancy
             frequency within a single axis frame.

   col.S: Color for salinity profile.

   col.t: Color for temperature.

 col.rho: Color for density.

  col.N2: Color for square of buoyancy frequency.

    grid: Set 'TRUE' to get a grid.

col.grid: Grid colour.

     ...: Optional arguments passed to other functions.  A common
          example is to set 'df', for  use in sw.N2 calculations.

_D_e_t_a_i_l_s:

_V_a_l_u_e:

     None.

_A_u_t_h_o_r(_s):

     Dan Kelley Dan.Kelley@Dal.Ca

_R_e_f_e_r_e_n_c_e_s:

_S_e_e _A_l_s_o:

     'read.ctd' scans ctd information from a file, and 'plot.TS' plots
     a temperature-salinity diagram.

_E_x_a_m_p_l_e_s:

     ## Not run: 
     library(oce)
     data(ctd)
     # ctd <- read.ctd("ctd.cnv")
     summary(ctd)
     plot(ctd)
     plot.profile(ctd, type="T")
     ## End(Not run)

