sw.S.C.T.p                package:oce                R Documentation

_S_e_a_w_a_t_e_r _s_a_l_i_n_i_t_y _f_r_o_m _c_o_n_d_u_c_t_i_v_i_t_y _r_a_t_i_o, _t_e_m_p_e_r_a_t_u_r_e _a_n_d _p_r_e_s_s_u_r_e

_D_e_s_c_r_i_p_t_i_o_n:

     Compute salinity, given conductivity ratio, temperature, and
     pressure.

_U_s_a_g_e:

       S <- sw.S.C.T.p(C, t, p);

_A_r_g_u_m_e_n_t_s:

       C: conductivity ratio [unitless]

       t: _in-situ_ temperature [degC]

       p: pressure [dbar]

_D_e_t_a_i_l_s:

     Calculate S from what is actually measured by the CTD, _i.e._ the
     conductivity ratio C, the _in-situ_ temperature T, and the
     pressure p. Often this is done by the CTD processing software, but
     sometimes it is helpful to do this directly, _e.g._ when there is
     a concern about mismatches in sensor response times.   S is
     calculated using the UNESCO algorithm  described by Fofonoff and
     Millard (1983).

_V_a_l_u_e:

     Salinity [PSU].

_A_u_t_h_o_r(_s):

     Dan Kelley Dan.Kelley@Dal.Ca

_R_e_f_e_r_e_n_c_e_s:

     Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for
     computation of fundamental properties of seawater. _Unesco
     Technical Papers in Marine Science_, *44*, 53 pp

_S_e_e _A_l_s_o:

     'sw.conductivity'

_E_x_a_m_p_l_e_s:

     print(sw.S.C.T.p(1,15,2000))   # 34.25045
     print(sw.S.C.T.p(1.2,20,2000)) # 37.24563
     print(sw.S.C.T.p(0.65,5,1500)) # 27.99535

