prior.b               package:emulator               R Documentation

_P_r_i_o_r _l_i_n_e_a_r _f_i_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Gives the fitted regression coefficients corresponding to the
     specified regression model.

_U_s_a_g_e:

     prior.b(H, Ainv, d, b0 = NULL, B0 = NULL)
     prior.B(H , Ainv , B0=NULL)

_A_r_g_u_m_e_n_t_s:

       H: Regression basis function (eg that returned by
          'regressor.multi()')

    Ainv: inv(A) where A is a correlation matrix  (eg that returned by
          'corr.matrix()')

       d: Vector of data points

      b0: prior constant

      B0: prior coefficients

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

        *  J. Oakley 2004. _Estimating percentiles of uncertain
           computer code outputs_.  Applied Statistics, 53(1), pp89-93.

        *  J. Oakley 1999. _Bayesian uncertainty analysis for complex
           computer codes_, PhD thesis, University of Sheffield.

_E_x_a_m_p_l_e_s:

     # example has 10 observations on 6 dimensions.
     # function is just sum( (1:6)*x) where x=c(x_1, ... , x_2)

     data(toy)
     val <- toy
     d <- apply(val,1,function(x){sum((1:6)*x)})

     #add some noise:
     d <- jitter(d)

     A <- corr.matrix(val,scales=rep(1,ncol(val)), power=1.5)
     Ainv <- solve(A)
     H <- regressor.multi(val)

     prior.b(H,Ainv,d)
     prior.B(H,Ainv)

