c.fun              package:approximator              R Documentation

_C_o_r_r_e_l_a_t_i_o_n_s _b_e_t_w_e_e_n _p_o_i_n_t_s _i_n _p_a_r_a_m_e_t_e_r _s_p_a_c_e

_D_e_s_c_r_i_p_t_i_o_n:

     Correlation matrices between (sets of) points in parameter space,
     both prior ('c_fun()') and posterior ('cdash.fun()').

_U_s_a_g_e:

     c_fun(x, xdash=x, subsets, hpa)
     cdash.fun(x, xdash=x, V=NULL, Vinv=NULL, D1, subsets, basis, hpa, method=2)

_A_r_g_u_m_e_n_t_s:

 x,xdash: Points in parameter space; or, if a matrix, interpret the
          rows as points in parameter space.  Note that the default
          value of 'xdash' (viz 'x') will return the
          variance-covariance matrix of a set of points.

      D1: Design matrix

 subsets: Subset object

     hpa: hyperparameter object

   basis: Basis function

  V,Vinv: In function 'cdash.fun()', the data covariance matrix and its
          inverse.  If 'NULL', the matrix will be calculated from
          scratch.  Supplying a precalculated value for 'V', and
          especially 'Vinv', makes for very much faster execution
          (edepending on 'method')

  method: Integer specifying which of several algebraically identical
          methods to use.  See the source code for details, but default
          option 2 seems to be the best.  Bear in mind that option 3
          does not require inversion of a matrix, but is not faster in
          practice.

_V_a_l_u_e:

     Returns a matrix of covariances

_N_o_t_e:

     Do not confuse function 'c_fun()', which computes c(x,x') defined
     just below equation 7 on page 4 with c_t(x,x') defined in equation
     3 on page 3.

     Consider the example given for two levels on page 4 just after
     equation 7: c(x,x')=c_2(x,x')+rho_1^2c_1(x,x') is a kind of prior
     covariance matrix.  Matrix c'(x,x') is a posterior covariance
     matrix, conditional on the code observations.

     Function 'A()' evaluates c_t(x,x') in a nice vectorized way.

     Equation 7 of KOH2000 contains a typo.

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

     KOH2000

_S_e_e _A_l_s_o:

     'A'

_E_x_a_m_p_l_e_s:

     data(toyapps)

     x <- latin.hypercube(4,3)
     rownames(x) <- c("ash" , "elm" , "oak", "pine")
     xdash <- latin.hypercube(7,3)
     rownames(xdash) <- c("cod","bream","skate","sole","eel","crab","squid")

     cdash.fun(x=x,xdash=xdash, D1=D1.toy, basis=basis.toy,subsets=subsets.toy, hpa=hpa.toy)

     # Now add a point whose top-level value is known:
     x <- rbind(x,D1.toy[subsets.toy[[4]][1],])

     cdash.fun(x=x,xdash=xdash, D1=D1.toy, basis=basis.toy,subsets=subsets.toy, hpa=hpa.toy)
     # Observe how the bottom row is zero (up to rounding error)

