### Name: corr
### Title: correlation function for calculating A
### Aliases: corr corr.matrix
### Keywords: models

### ** Examples

corr(1:10,10:1,scales=rep(1,10), power=2)
corr(1:10,10:1,pos.def.matrix=0.1+diag(10),power=2)
x <- latin.hypercube(4,7)  #4 points in 7-dimensional space
corr.matrix(x,scales=rep(1,7),power=1.5)

x[1,1] <- 100
corr.matrix(x,scales=rep(1,7), power=1.5)

# note that all the first row and first column apart from the [1,1]th
# element is zero (or very nearly so) because point number 1 is now very
# far from the other points.

#to use just a single dimension, remember to use the drop=FALSE argument:
corr.matrix(x[,1,drop=FALSE],scales=rep(1,1),power=1.5)

# For problems in 1D, coerce the independent variable to a matrix:
m <- c(0.2 , 0.4,0.403,0.9)
corr.matrix(cbind(m),scales=1)

# now use a non-default value for distance.function.
# Function f() below taken from Oakley's thesis page 12,
# equation 2.10:

f <- function(x,y,theta){
  d <- sum(abs(x-y))
  if(d >= theta){
    return(0)
  }else{
    return(1-d/theta)
  }
}

corr.matrix(xold=x, distance.function=f , method=2, theta=4)

 # Note the first row and first column is a single 1 and 3 zeroes
 # (because the first point, viz x[1,], is "far" from the other ponts).
 # Also note the method=2 argument here; method=1 is the fast slick
 # matrix method suggested by Doug and Jeremy, but this only works
 # for distance.function=corr.





