### Name: quad.form
### Title: Evaluate a quadratic form efficiently
### Aliases: quad.form quad.form.inv quad.3form quad.tform
### Keywords: array

### ** Examples

jj <- matrix(rnorm(80),20,4)
M <- crossprod(jj,jj)
M.lower <- t(chol(M))
x <- matrix(rnorm(8),4,2)

jj.1 <- t(x) %*% M %*% x
jj.2 <- quad.form(M,x)
jj.3 <- quad.form(M.lower,x,chol=TRUE)

print(jj.1)
print(jj.2)
print(jj.3)

## Now consider accuracy:
quad.form(solve(M),x) - quad.form.inv(M,x)  # should be zero

quad.form(M,x) - quad.tform(M,t(x)) # Should be zero




