beta1hat.fun           package:calibrator           R Documentation

_b_e_t_a_1 _e_s_t_i_m_a_t_o_r

_D_e_s_c_r_i_p_t_i_o_n:

     Least squares estimator for beta1

_U_s_a_g_e:

     beta1hat.fun(D1, H1, y, phi)

_A_r_g_u_m_e_n_t_s:

      D1: code run points

      H1: regressor basis funs

       y: code outputs

     phi: hyperparameters

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

        *  M. C. Kennedy and A. O'Hagan 2001. _Bayesian calibration of
           computer models_.  Journal of the Royal Statistical Society
           B, 63(3) pp425-464

        *  M. C. Kennedy and A. O'Hagan 2001.  _Supplementary details
           on Bayesian calibration of computer models_, Internal
           report, University of Sheffield.  Available at <URL:
           http://www.shef.ac.uk/~st1ao/ps/calsup.ps>

        *  R. K. S. Hankin 2005. _Introducing BACCO, an R bundle for
           Bayesian analysis of computer code output_, Journal of
           Statistical Software, 14(16)

_S_e_e _A_l_s_o:

     'beta2hat.fun'

_E_x_a_m_p_l_e_s:

     data(toys)
     y.toy <- create.new.toy.datasets(D1=D1.toy , D2=D2.toy)$y.toy
     beta1hat.fun(D1=D1.toy, H1=H1.toy, y=y.toy, phi=phi.toy)

           # now cheat: force the hyperparameters to have the correct psi1:
      phi.fix <- phi.change(old.phi=phi.toy,psi1=c(1, 0.5, 1.0, 1.0, 0.5, 0.4),phi.fun=phi.fun.toy)
           # The value for psi1 is obtained by cheating and #examining the source
           # code for computer.model(); see ?phi.change 

           # Create a new toy dataset with 40 observations:
     D1.big <- latin.hypercube(40,5)

     jj <- create.new.toy.datasets(D1=D1.big , D2=D2.toy)

           # We know that the real coefficients are 4:9 because we
           # we can cheat and look at the source code for computer.model()

           # Now estimate the coefficients without cheating:

     beta1hat.fun(D1=D1.big, H1=H1.toy, jj$y, phi=phi.toy)

          # Not bad!


          # We can do slightly better by cheating and using the
          # correct value for the hyperparameters:

     beta1hat.fun(D1=D1.big, H1=H1.toy, jj$y,phi=phi.true.toy(phi=phi.toy))

          #marginally worse.

