beta2hat.fun           package:calibrator           R Documentation

_e_s_t_i_m_a_t_o_r _f_o_r _b_e_t_a_2

_D_e_s_c_r_i_p_t_i_o_n:

     estimates beta2 as per the equation of page 4 of the supplement. 
     Used by 'p.page4()'

_U_s_a_g_e:

     beta2hat.fun(D1, D2, H1, H2, V, z, etahat.d2, extractor, E.theta,
     Edash.theta, phi)

_A_r_g_u_m_e_n_t_s:

      D1: Matrix of code run points

      D2: Matrix of observation points

      H1: regression basis functions

      H2: regression basis functions

       V: overall covariance matrix

       z: vector of observations

etahat.d2: expectation as per 'etahat.vector'

extractor: extractor function

 E.theta: Expectation

Edash.theta: Expectation wrt thetadash

     phi: hyperparameters

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

        *  M. C. Kennedy and A. O'Hagan 2001. _Bayesian calibration of
           computer models_.  Journal of the Royal Statistical Society
           B, 63(3) pp425-464

        *  M. C. Kennedy and A. O'Hagan 2001.  _Supplementary details
           on Bayesian calibration of computer models_, Internal
           report, University of Sheffield.  Available at <URL:
           http://www.shef.ac.uk/~st1ao/ps/calsup.ps>

        *  R. K. S. Hankin 2005. _Introducing BACCO, an R bundle for
           Bayesian analysis of computer code output_, Journal of
           Statistical Software, 14(16)

_S_e_e _A_l_s_o:

     'W2'

_E_x_a_m_p_l_e_s:

     data(toys)

     etahat.d2 <- etahat(D1=D1.toy, D2=D2.toy, H1=H1.toy, y=y.toy,
     E.theta=E.theta.toy, extractor=extractor.toy, phi=phi.toy)

     beta2hat.fun(D1=D1.toy, D2=D2.toy, H1=H1.toy, H2=H2.toy, V=NULL,
     z=z.toy, etahat.d2=etahat.d2, extractor=extractor.toy,
     E.theta=E.theta.toy, Edash.theta=Edash.theta.toy, phi=phi.toy)

     jj <- create.new.toy.datasets(D1.toy , D2.toy)
     phi.true <- phi.true.toy(phi=phi.toy)
     y.toy <- jj$y.toy
     z.toy <- jj$z.toy
     d.toy <- jj$d.toy

     etahat.d2 <- etahat(D1=D1.toy, D2=D2.toy, H1=H1.toy, y=y.toy,
     E.theta=E.theta.toy, extractor=extractor.toy, phi=phi.toy)

     beta2hat <- beta2hat.fun(D1=D1.toy, D2=D2.toy, H1=H1.toy, H2=H2.toy, V=NULL,
     z=z.toy, etahat.d2=etahat.d2, extractor=extractor.toy,
     E.theta=E.theta.toy, Edash.theta=Edash.theta.toy,
     phi=phi.toy)

     print(beta2hat)

     plot(z.toy , H2.toy(D2.toy) %*% beta2hat) 

