### Name: BootCL.plot
### Title: Display the bootstrap distribution and p-value
### Aliases: BootCL.plot
### Keywords: distribution

### ** Examples

     library(BootCL)
     chip.name<-"HG.U133A"
     data(affy.hgu133a)
     sample.cluster<-affy.hgu133a[sample(1:1000,100),1]
     sample.ID<-find.ID(chip.name,sample.cluster,affyID.flag=TRUE) 
     Boot.Stat<-BootCL.Statistic(chip.name,sample.ID)
     Bdist<-BootCL.distribution(chip.name,Boot.Stat$sampling.count,total.sampling.count=10000)
     BootP<-BootCL.Pvalue(Boot.Stat,Bdist)
     BootCL.plot(BootP)



