### Name: cor.bootci
### Title: Bootstrap Confidence Interval for Multivaraite Correlation
### Aliases: cor.bootci
### Keywords: multivariate cluster models htest

### ** Examples

library("CORREP")
d0 <- NULL
## sample size is set to 5 
for(l in 1:5)
d0 <- rbind(d0, rnorm(8))
## data must have row variance of 1 
d0.std <- apply(d0, 2, function(x) x/sd(x))
M <- cor.balance(t(d0.std), m = 2, G= 4)
pv.bootci <- cor.bootci(t(d0.std), m = 2, G= 4, alpha = 0.05)



