### Name: cor.unbalance
### Title: Multivariate Correlation Estimator (Unequal Number of
###   Replicates)
### Aliases: cor.unbalance
### Keywords: multivariate cluster models htest

### ** Examples

library("CORREP")
d0 <- NULL
for(l in 1:10)
d0 <- rbind(d0, rnorm(8))
## The simulated data corresponds to the real-world data of 2 genes and 10 conditions, gene expression
## profiles were replicated 3 and 5 times. 
## Note this function can only take calculate correlation matrix between two genes at a time.
d0<- t(d0)
## This step is to make the standard deviation of each replicate equal to 1
## so that we can model the covariance matrix as correlation matrix.
d0.std <- apply(d0, 1, function(x) x/sd(x))
M <- cor.unbalance(t(d0.std), m1=3, m2=5)



