besagnewell.boot          package:DCluster          R Documentation

_G_e_n_e_r_a_t_e _b_o_o_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _B_e_s_a_g _a_n_d _N_e_w_e_l_l'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate boostrap replicates of Besag and Newell's statistic, by
     means of function _boot_ from _boot_ library.  Notice that these
     functions should not  be used separately but as argument
     _statistic_ when calling function _boot_.

     _besagnewell.boot_ is used when performing a non-parametric
     bootstrap.

     When sampling models are _Multinomial_ or _Poisson_ it is quite
     straightforwad to obtain the actual p-value as shown in the
     examples. When _Permutation_ or _Negative Binomial_ are used,
     simulation must be used to estimate significance.

_U_s_a_g_e:

     besagnewell.boot(data, i, ...)
     besagnewell.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe with the data, as explained in _DCluster_.

       i: Permutation generated by the non-parametric bootstrap.

     ...: Additional arguments needed.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Besag, J. and Newell, J.(1991). The detection of clusters in rare
     diseases.  Journal of the Royal Statistical Society A  154,
     143-155.

_S_e_e _A_l_s_o:

     DCluster, boot, besagnewell, besagnewell.stat, bn.iscluster

_E_x_a_m_p_l_e_s:

     library(boot)
     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
     sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

     niter<-100

     #Permutation  model
     besn.perboot<-boot(sids, statistic=besagnewell.boot, R=niter, k=20)
     plot(besn.perboot)#Display results

