moranI.boot             package:DCluster             R Documentation

_G_e_n_e_r_a_t_e _b_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _M_o_r_a_n'_s _I _a_u_t_o_c_o_r_r_e_l_a_t_i_o_n _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of Moran's I autocorrelation
     statistic, by means of function _boot_ form _boot_ library. Notice
     that these functions should not  be used separately but as
     argument _statistic_ when calling function _boot_.

     _moranI.boot_ is used when performing a non-parametric bootstrap.

     _moranI.pboot_ is used when performing a parametric bootstrap.

_U_s_a_g_e:

     moranI.boot(data, i, ...)
     moranI.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe containing the data, as specified in the 
          *DCluster*manpage.

       i: Permutation generated by the bootstrap procedure

     ...: Aditional arguments passed when performing a bootstrap.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Moran, P. A. P. (1948). The interpretation os statistical maps.
     Journal of the Royal Statistical Society, Series B 10, 243-251.

_S_e_e _A_l_s_o:

     DCluster, boot, moranI, moranI.stat

_E_x_a_m_p_l_e_s:

     library(spdep)
     data(nc.sids)
     col.W <- nb2listw(ncCR85.nb, zero.policy=TRUE)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74)) 

     niter<-100

     #Permutation model
     moran.boot<-boot(sids, statistic=moranI.boot, R=niter, listw=col.W, 
             n=length(ncCR85.nb), S0=Szero(col.W) )
     plot(moran.boot)#Display results

     #Multinomial model
     moran.mboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
             ran.gen=multinom.sim,  R=niter, listw=col.W,n=length(ncCR85.nb), 
             S0=Szero(col.W) )
     plot(moran.mboot)#Display results

     #Poisson model
     moran.pboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
             ran.gen=poisson.sim,  R=niter, listw=col.W,n=length(ncCR85.nb),
             S0=Szero(col.W) )
                     
     plot(moran.pboot)#Display results

     #Poisson-Gamma model
     moran.pgboot<-boot(sids, statistic=moranI.pboot, sim="parametric", 
             ran.gen=negbin.sim, R=niter,  listw=col.W,n=length(ncCR85.nb),
             S0=Szero(col.W) )
                     
     plot(moran.pgboot)#Display results

