stone.boot             package:DCluster             R Documentation

_G_e_n_e_r_a_t_e _b_o_o_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _S_t_o_n_e'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of Stone's statictic, by means of
     function _boot_ from _boot_ package. Notice that these functions
     should not be used separately but as argument _statistic_ when
     calling function _boot_.

     _stone.boot_ is used when performing a non-parametric bootstrap.

     _stone.pboot_ is used when performing a parametric bootstrap.

_U_s_a_g_e:

     stone.boot(data, i, ...)
     stone.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe with all the data, as explained in the _DCluster_
          manual page.

       i: Permutation created in non-parametric bootstrap.

     ...: Additional arguments passed to the functions.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Stone, R. A. (1988). Investigating of excess environmental risks
     around putative sources: Statistical problems and a proposed test.
     Statistics in Medicine 7,649-660.

_S_e_e _A_l_s_o:

     DCluster, boot, stone.stat

_E_x_a_m_p_l_e_s:

     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74))
     sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

     niter<-100

     #All Tests are performed around county 78.

     #Permutation  model
     st.perboot<-boot(sids, statistic=stone.boot, R=niter, region=78)
     plot(st.perboot)#Display results

     #Multinomial model
     st.mboot<-boot(sids, statistic=stone.pboot, sim="parametric", ran.gen=multinom.sim,  R=niter, region=78)
     plot(st.mboot)#Display results

     #Poisson model
     st.pboot<-boot(sids, statistic=stone.pboot, sim="parametric", ran.gen=poisson.sim,  R=niter, region=78)
     plot(st.pboot)#Display results

     #Poisson-Gamma model
     st.pgboot<-boot(sids, statistic=stone.pboot, sim="parametric", ran.gen=negbin.sim, R=niter, region=78)
     plot(st.pgboot)#Display results

