whittermore.boot          package:DCluster          R Documentation

_G_e_n_e_r_a_t_e _b_o_o_t_s_t_r_a_p _r_e_p_l_i_c_a_t_e_s _o_f _W_h_i_t_t_e_r_m_o_r_e'_s _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     Generate bootstrap replicates of Whittermore's statistic by means
     of function _boot_ from _boot_ library. Notice that these
     functions should not be used separately but as argument
     _statistic_ when calling function _boot_.

     _whittermore.boot_ is used to perform a non-parametric bootstrap

     _whittermore.pboot_ is used when using parametric bootstrap.

_U_s_a_g_e:

     whittermore.boot(data, i, ...)
     whittermore.pboot(...)

_A_r_g_u_m_e_n_t_s:

    data: A dataframe with the data as explained in _DCluster_.

       i: Permutation generated by the non-parametric bootstrap
          procedure.

     ...: Additional arguments passed when performing a bootstrap.

_V_a_l_u_e:

     Both functions return the value of the statistic.

_R_e_f_e_r_e_n_c_e_s:

     Whittermore, A. S. and Friend, N. and Byron, W. and Brown, J. R.
     and Holly, E. A. (1987). A test to detect clusters of disease.
     Biometrika 74, 631-635.

_S_e_e _A_l_s_o:

     DCluster, boot, whittermore, whittermore.stat

_E_x_a_m_p_l_e_s:

     library(boot)
     library(spdep)

     data(nc.sids)

     sids<-data.frame(Observed=nc.sids$SID74)
     sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74) )
     sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

     #Calculate neighbours based on distance
     coords<-as.matrix(sids[,c("x", "y")])

     dlist<-dnearneigh(coords, 0, Inf)
     dlist<-include.self(dlist)
     dlist.d<-nbdists(dlist, coords)

     #Calculate weights. They are globally standardised but it doesn't
     #change significance.
     col.W.whitt<-nb2listw(dlist, glist=dlist.d, style="C")

     niter<-100

     #Permutation model
     wt.boot<-boot(sids, statistic=whittermore.boot, R=niter, listw=col.W.whitt,
             zero.policy=TRUE)
     plot(wt.boot)#Display results

     #Multinomial model
     wt.mboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
             ran.gen=multinom.sim,  R=niter,  listw=col.W.whitt, zero.policy=TRUE)
                     
     plot(wt.mboot)#Display results

     #Poisson model
     wt.pboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
             ran.gen=poisson.sim,  R=niter,  listw=col.W.whitt, zero.policy=TRUE)
                     
     plot(wt.pboot)#Display results

     #Poisson-Gamma model
     wt.pgboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
             ran.gen=negbin.sim, R=niter, listw=col.W.whitt, zero.policy=TRUE)
     plot(wt.pgboot)#Display results

