### Name: xmp10.05
### Title: data from Example 10.5
### Aliases: xmp10.05
### Keywords: datasets

### ** Examples

data(xmp10.05)
plot(REMtime ~ ethanol, data = xmp10.05,
     xlab = "Ethanol concentration administered (g/kg)",
     ylab = "Amount of REM sleep during a 24 hour period")
fm1 <- lm(REMtime ~ factor(ethanol), data = xmp10.05)
anova(fm1)      # compare with Table 10.4, p. 417
summary(fm1)    # differences with baseline (0 g/kg)
##  more appropriate to use an ordered factor
fm2 <- lm(REMtime ~ ordered(ethanol), data = xmp10.05)
anova(fm2)      # same as above
summary(fm2)    # polynomial contrasts
##  best model uses square root of ethanol concentration
plot(REMtime ~ sqrt(ethanol), data = xmp10.05,
     xlab = expression(sqrt(
        plain("Ethanol concentration administered (g/kg)"))),
     ylab = "Amount of REM sleep during a 24 hour period")
fm3 <- lm(REMtime ~ sqrt(ethanol), data = xmp10.05)
summary(fm3)
abline(fm3)
anova(fm3, fm1)   # lack of fit test
opar <- par(mfrow = c(2,2))
plot(fm3, main = "Continuous fit to data in Example 10.5")
par(opar)



