### Name: HTMLapplets.data.frame
### Title: HTMLapplets.data.frame
### Aliases: HTMLapplets.data.frame HTMLapplets


### ** Examples

data(ChickWeight)

l <- split(ChickWeight[,c("Time","weight")], ChickWeight$Chick)
for(i in 1:length(l)) names(l[[i]]) <- c("Time",paste("Chick",i,sep=""))
chicks <- data.frame(Time=sort(unique(ChickWeight$Time)))
for(i in 1:length(l))
  chicks <- merge(chicks,l[[i]], all=TRUE)
mean <- apply(chicks,1,mean, na.rm=TRUE)
sd <- apply(chicks,1,sd, na.rm=TRUE)

cat("CREATING \"./chicksGrid.html\"\n")

HTMLInitFile("./","chicksGrid")
HTML.title("HTMLapplets")
# grid
HTMLapplets.data.frame(chicks[,1:10],height=100)
HTMLEndFile()



