### Name: HTMLapplets.plot
### Title: HTMLapplets.plot
### Aliases: HTMLapplets.plot


### ** Examples

data(ChickWeight)

l <- split(ChickWeight[,c("Time","weight")], ChickWeight$Chick)
for(i in 1:length(l)) names(l[[i]]) <- c("Time",paste("Chick",i,sep=""))
chicks <- data.frame(Time=sort(unique(ChickWeight$Time)))
for(i in 1:length(l))
  chicks <- merge(chicks,l[[i]], all=TRUE)
mean <- apply(chicks,1,mean, na.rm=TRUE)
sd <- apply(chicks,1,sd, na.rm=TRUE)

cat("CREATING \"./chicksPlot.html\"\n")

# first plot
HTMLInitFile("./","chicksPlot1")
HTML.title("HTMLapplets")
HTMLapplets.plot(id="all",
            x=chicks$Time,
            y=chicks[,2:10],
            xlab="time", ylab="Weight", main="Test1",
            xlim=c(8,13), ylim=c(50,100),
            type="l", pch=1, height=250, help=TRUE)
HTMLEndFile()
# second plot
HTMLInitFile("./","chicksPlot2")
HTML.title("HTMLapplets")
HTMLapplets.plot(id="summary",
            x=chicks$Time,
            y=mean,
            xlab="time", ylab="Weight", type="l", main="Test2",
            pch=1, height=250, background="e0e0e0",
            data.link=FALSE,
            diameter=round(mean/max(mean)*20+1),
            col=gsub("#","",rgb(1-mean/max(mean),0,mean/max(mean))),
            low.error=mean-sd, high.error=mean+sd)
HTMLEndFile()



