### Name: alternative.probable
### Title: alternative.probable and alternative.beneficial
### Aliases: alternative.probable alternative.beneficial
### Keywords: htest nonparametric

### ** Examples


n.variables <- 1000 # This could be the number of genes on a microarray.
n.individuals <- 5 # This could be the number of microarrays per group.
n.effects <- 100 # This is the number of alternative hypotheses that are true, e.g., number of genes differentially expressed.
x1 <- matrix(c(rnorm(n.effects * n.individuals, mean = 2, sd = 1), rnorm((n.variables - n.effects) * n.individuals, mean = 0, sd = 1)), nrow = n.variables, byrow = TRUE) # Observed data, e.g., logarithms of gene expression ratios, for group 1.
x2 <- matrix(rnorm(n.variables * n.individuals, mean = 0, sd = 1), nrow = n.variables, byrow = TRUE) # The same for group 2.
p.values <- numeric(n.variables)
for(i in 1:n.variables) p.values[i] <- t.test(x1[i, ], x2[i, ])$p.value
is.probable <- alternative.probable(p.values) # Selects which alternative hypotheses are probably true, e.g., which genes are probably differentially expressed.
c(sum(is.probable[1:100]), sum(is.probable[101:1000])) # Numbers of true and false calls of differential expression.
is.probable.95 <- alternative.probable(p.values, min.probability = .95) # To be at least 95
c(sum(is.probable.95[1:100]), sum(is.probable.95[101:1000])) # Smaller numbers of true and false calls of differential expression.
is.beneficial <- alternative.beneficial(p.values, cost.to.benefit = 1)
all.equal(is.beneficial, is.probable)




