### Name: plot.joint
### Title: Model Checking
### Aliases: plot.joint obs.vs.model rstand.vs.linpred res.vs.explvar
###   absres.vs.fitted adjvar.vs.linpred qqglm
### Keywords: hplot

### ** Examples

X <- rnorm(500, 5)
mu <- 2*X + 1
sigma2 <- exp(-X)
Y <- rnorm(500, mu, sqrt(sigma2))
data.frm <- data.frame(Y=Y, X=X)
ajust <- fitjoint("glm", 'Y~X', 'd~X', data = data.frm)
layout(matrix(c(1,1,2,2,3,3,4,4,0,5,5,0),3,byrow=TRUE))
plot(ajust, var = 'X')



