### Name: judgeit
### Title: judgeit
### Aliases: judgeit JudgeIt
### Keywords: models

### ** Examples


#Demo files are available through the following commands:
demo(seatsdemo)
demo(probdemo)
demo(svsumdemo)
demo(distreportdemo)

data(house6311)
#columns: STATE,DIST,INC,VOTE,TURNOUT,DELSOUTH

#operators:
unc <- function(inp) -1*(inp<0.05)+1*(inp>0.95)

years <- seq (1896,1992,by=2)
same.dists <- rep(1,49); same.dists[seq(4,49,by=5)] <- 0

j.ob <- judgeit(model.formula=VOTE~unc(VOTE)+INC,vote.formula=TURNOUT~1,
               data=house6311,
               use.last.votes=T,subset=DELSOUTH==0,same.d=same.dists)

summary(j.ob)
summary(j.ob,which(years==1942))

j.ob <- judgeit(routine="distreport",judgeit.object=j.ob,year=which(years==1962),new.covariates=list("INC",0),vote.range=c(0.1,0.9))
j.ob

#seats-votes curve
j.ob <- judgeit(routine="seats",jud=j.ob,year=which(years==1986),vote.range=c(0.2,0.8))
plot(j.ob)




