ci.R2                 package:MBESS                 R Documentation

_C_o_n_f_i_d_e_n_c_e _i_n_t_e_r_v_a_l_s _f_o_r _t_h_e _s_q_u_a_r_e_d _m_u_l_t_i_p_l_e _c_o_r_r_e_l_a_t_i_o_n _c_o_e_f_f_i_c_i_e_n_t

_D_e_s_c_r_i_p_t_i_o_n:

     A function to calculate the exact confidence interval for the
     multiple correlation coefficient.

_U_s_a_g_e:

     ci.R2(R2 = NULL, df.1 = NULL, df.2 = NULL, conf.level = .95, 
     Random.Predictors=TRUE, Random.Regressors, F.value = NULL, N = NULL, p = NULL, 
     K, alpha.lower = NULL, alpha.upper = NULL, tol = 1e-09)

_A_r_g_u_m_e_n_t_s:

      R2: multiple correlation coefficient

    df.1: numerator degrees of freedom

    df.2: denominator degrees of freedom

conf.level: confidence interval coverage; 1-Type I error rate

Random.Predictors: whether or not the predictor variables are random or
          fixed (random is default)

Random.Regressors: an alias for 'Random.Predictors';
          'Random.Regressors' overrides 'Random.Predictors'

 F.value: obtained 'F'-value

       N: sample size

       p: number of predictors

       K: alias for 'p', the number of predictors

alpha.lower: Type I error for the lower confidence limit

alpha.upper: Type I error for the upper confidence limit

     tol: tolerance for iterative convergence

_D_e_t_a_i_l_s:

     This function can be used with random predictor variables
     ('Random.Predictors=TRUE') or when predictor variables are fixed
     ('Random.Predictors=FALSE'). In most applications in the
     _behavioral, educational, and social sciences_ predictor variables
     are random, which is the default in this function. 

     For random predictors, the function implements the procedure of
     Lee (1971), which was implemented by  Algina and Olejnik (2000;
     specifically in their _ci.smcc.bisec.sas_ SAS script). When
     'Random.Predictors=TRUE', the function implements code that is in
     part based on the Alginia and Olejnik (2000) SAS script. 

     When 'Random.Predictors=FALSE', and thus the predictors are
     planned and thus fixed in  hypothetical replications of the study,
     the confidence limits are based on a noncentral 'F'-distribution
     (see 'conf.limits.ncf').

_V_a_l_u_e:

Lower.Conf.Limit.R2 : upper limit of the confidence interval around the
          population multiple correlation coefficient

Prob.Less.Lower : proportion of the distribution less than
          'Lower.Conf.Limit.R2'

Upper.Conf.Limit.R2 : upper limit of the confidence interval around the
          population multiple correlation coefficient

Prob.Greater.Upper : proportion of the distribution greater than
          'Lower.Conf.Limit.R2'

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_R_e_f_e_r_e_n_c_e_s:

     Algina, J. & Olejnik, S. (2000) Determining Sample Size for
     Accurate Estimation of  the Squared Multiple Correlation
     Coefficient. _Multivariate Behavioral Research, 35_,  119-136.

     Lee, Y. S. (1971). Some results on the sampling distribution of
     the multiple correlation coefficient. _Journal of the Royal
     Statistical Society, B, 33_, 117-130.

     Smithson, M. (2003). _Confidence intervals_. New York, NY: Sage
     Publications. 

     Steiger, J. H. & Fouladi, R. T. (1992) R2: {A} computer program
     for interval estimation, power calculation, and hypothesis testing
     for the squared multiple correlation. _Behavior research methods,
     instruments and computers, 4_, 581-582.

_S_e_e _A_l_s_o:

     'ss.aipe.R2', 'conf.limits.nct'

_E_x_a_m_p_l_e_s:

     # For random predictor variables.
     ci.R2(R2=.25, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

     ci.R2(F.value=6.266667, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

     # For fixed predictor variables.
     ci.R2(R2=.25, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

     ci.R2(F.value=6.266667, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

     # One sided confidence intervals when predictors are random.
     ci.R2(R2=.25, N=100, K=5, alpha.lower=.05, alpha.upper=0, conf.level=NULL,
     Random.Predictors=TRUE)

     ci.R2(R2=.25, N=100, K=5, alpha.lower=0, alpha.upper=.05, conf.level=NULL,
     Random.Predictors=TRUE)

     # One sided confidence intervals when predictors are fixed.
     ci.R2(R2=.25, N=100, K=5, alpha.lower=.05, alpha.upper=0, conf.level=NULL,
     Random.Predictors=FALSE)

     ci.R2(R2=.25, N=100, K=5, alpha.lower=0, alpha.upper=.05, conf.level=NULL,
     Random.Predictors=FALSE)

