ci.c                  package:MBESS                  R Documentation

_C_o_n_f_i_d_e_n_c_e _i_n_t_e_r_v_a_l _f_o_r _a _c_o_n_t_r_a_s_t _i_n _a _f_i_x_e_d _e_f_f_e_t_s _A_N_O_V_A

_D_e_s_c_r_i_p_t_i_o_n:

     Function to calculate the exact confidence interval for a contrast
     in a fixed effects analysis of variance context.

_U_s_a_g_e:

     ci.c(means = NULL, error.variance = NULL, c.weights = NULL, n = NULL, N = NULL, 
     Psi = NULL, conf.level = 0.95, alpha.lower = NULL, alpha.upper = NULL, 
     df.error = NULL, ...)

_A_r_g_u_m_e_n_t_s:

   means: a vector of the group means or the means of the particular
          level of the effect (for fixed effect designs) 

error.variance: the common variance of the error (i.e., the mean square
          error) 

c.weights: the contrast weights (the sum of the contrast weights should
          be zero) 

       n: sample sizes per group or level of the particular factor (if
          length 1 it is assumed that the per group/level sample sizes
          are equal) 

       N: total sample size 

     Psi: the (unstandardized) contrast effect, obtained by multiplying
          the _j_th mean by the jth contrast weight (this is the
          unstandardized effect) 

conf.level: confidence interval coverage (i.e., 1- Type I error rate);
          default is .95 

alpha.lower: Type I error for the lower confidence limit 

alpha.upper: Type I error for the upper confidence limit

df.error: the degrees of freedom for the error. In one-way designs,
          this is simply _N_-length (means) and need not be specified;
          it must be specified if the design has multiple factors. 

     ...: allows one to potentially include parameter values for inner
          functions 

_D_e_t_a_i_l_s:

_V_a_l_u_e:

     Returns the confidence limits for the contrast: 

Lower.Conf.Limit.Contrast : The lower confidence limit for the contrast
          effect

Contrast : the value of the estimated unstandardized contrast effect

Upper.Conf.Limit.Contrast: The upper confidence limit for the contrast
          effect

_N_o_t_e:

     Be sure to use the error varaince and not its square root (i.e.,
     the standard deviation of the errors).

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University, <KKIII@Indiana.edu>)

_R_e_f_e_r_e_n_c_e_s:

     Steiger, J. H. (2004). Beyond the _F_ Test: Effect size confidence
     intervals and tests of close fit in the  Analysis of Variance and
     Contrast Analysis. _Psychological Methods, 9_, 164-182.

_S_e_e _A_l_s_o:

     'conf.limits.nct', 'ci.sc', 'ci.src', 'ci.smd', 'ci.smd.c',
     'ci.sm'

_E_x_a_m_p_l_e_s:

     ci.c(means=c(2, 4, 9, 13), error.variance=1, c.weights=c(1, -1, -1, 1), 
     n=c(3, 3, 3, 3), N=12, conf.level=.95)

     ci.c(means=c(2, 4, 9, 13), error.variance=1, c.weights=c(1, -1, -1, 1), 
     n=c(3, 3, 3, 3), N=12, conf.level=.95)

     ci.c(means=c(1.6, 0), error.variance=1, c.weights=c(1, -1), n=c(10, 10), 
     N=20, conf.level=.95)

     # An example given by Maxwell and Delaney (2004, pp. 155--171) :
     # 24 subjects of mild hypertensives are assigned to one of four treatments: drug 
     # therapy, biofeedback, dietary modification, and a treatment combining all the 
     # three previous treatments. Subjects' blood pressure is measured two weeks
     # after the termination of treatment. Now we want to form a 95
     # confidence interval for the difference in blood pressure between subjects
     # received drug treatment and those received biofeedback treatment 

     ## Drug group's mean = 94; group size=4
     ## Biofeedback group's mean = 91; group size=6 
     ## Diet group's mean = 92; group size=5
     ## Combination group's mean = 83; group size=5
     ## Mean Square Within (i.e., 'error.variance') = 67.375

     ci.c(means=c(94, 91, 92, 83), error.variance=67.375, c.weights=c(1, -1, 0, 0), 
     n=c(4, 6, 5, 5), N=20, conf.level=.95)

