ci.sc                 package:MBESS                 R Documentation

_C_o_n_f_i_d_e_n_c_e _I_n_t_e_r_v_a_l _f_o_r _a _S_t_a_n_d_a_r_d_i_z_e_d _C_o_n_t_r_a_s_t _i_n _a _F_i_x_e_d _E_f_f_e_t_s _A_N_O_V_A

_D_e_s_c_r_i_p_t_i_o_n:

     Function to obtain the confidence interval for a standardized
     contrast in a fixed effets analysis of variance context.

_U_s_a_g_e:

     ci.sc(means = NULL, error.variance = NULL, c.weights = NULL, n = NULL, 
     N = NULL, Psi = NULL, ncp = NULL, conf.level = 0.95, 
     alpha.lower = NULL, alpha.upper = NULL, df.error = NULL, ...)

_A_r_g_u_m_e_n_t_s:

   means: a vector of the group means or the means of the particular
          level of the effect (for fixed effect designs) 

error.variance: the common variance of the error (i.e., the mean square
          error) 

c.weights: the contrast weights (the sum of the contrast weights should
          be zero) 

       n: sample sizes per group or level of the particular factor (if
          length 1 it is  assumed that the per group/level sample sizes
          are equal) 

       N: total sample size 

     Psi: the (unstandardized) contrast effect, obtained by multiplying
          the _j_th mean  by the _j_th contrast weight (this is the
          unstandardized effect) 

     ncp: the noncentrality paramter from the t-distribution 

conf.level: desired level of confidence for the computed interval
          (i.e., 1 - the Type I error rate) 

alpha.lower: the Type I error rate for the lower confidence interval
          limit 

alpha.upper: the Type I error rate for the upper confidence interval
          limit 

df.error: the degrees of freedom for the error. In one-way designs,
          this is simply  _N_-length (means) and need not be specified;
          it must be specified if the design has multiple factors. 

     ...: optional additional specifications for nested functions 

_V_a_l_u_e:

Lower.Conf.Limit.Standardized.Contrast : the lower confidence limit for
          the standardized contrast

Standardized.contrast : standardized contrast

Upper.Conf.Limit.Standardized.Contrast: the upper confidence limit for
          the standardized contrast

_N_o_t_e:

     Be sure to use the error varaince and not its square root (i.e.,
     the standard deviation of the errors).

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University, <KKIII@Indiana.edu>)

_R_e_f_e_r_e_n_c_e_s:

     Kelley, K. (2006). Constructing confidence intervals for
     standardized effect sizes: Theory,  application, and
     implementation. _Manuscript submitted for publication_.

     Steiger, J. H. (2004). Beyond the _F_ Test: Effect size confidence
     intervals and tests of close fit in the  Analysis of Variance and
     Contrast Analysis. _Psychological Methods, 9_, 164-182.

_S_e_e _A_l_s_o:

     'conf.limits.nct', 'ci.src', 'ci.smd', 'ci.smd.c', 'ci.sm', 'ci.c'

_E_x_a_m_p_l_e_s:

     ci.sc(means=c(2, 4, 9, 13), error.variance=1, c.weights=c(1, -1, -1, 1), 
     n=c(3, 3, 3, 3), N=12, conf.level=.95)

     ci.sc(means=c(2, 4, 9, 13), error.variance=1, c.weights=c(1, -1, -1, 1), 
     n=c(3, 3, 3, 3), N=12, conf.level=.95)

     ci.sc(means=c(1.6, 0), error.variance=1, c.weights=c(1, -1), n=c(10, 10), 
     N=20, conf.level=.95)

