ci.smd.c                package:MBESS                R Documentation

_C_o_n_f_i_d_e_n_c_e _l_i_m_i_t_s _f_o_r _t_h_e _s_t_a_n_d_a_r_d_i_z_e_d _m_e_a_n _d_i_f_f_e_r_e_n_c_e _u_s_i_n_g _t_h_e _c_o_n_t_r_o_l
_g_r_o_u_p _s_t_a_n_d_a_r_d _d_e_v_i_a_t_i_o_n _a_s _t_h_e _d_i_v_i_s_o_r.

_D_e_s_c_r_i_p_t_i_o_n:

     Function to calculate the confidence limits for the standardized
     mean difference using the control group standard deviation as the
     divisor (Glass's g).

_U_s_a_g_e:

     ci.smd.c(ncp = NULL, smd.c = NULL, n.C = NULL, n.E = NULL, 
     conf.level = 0.95, alpha.lower = NULL, alpha.upper = NULL, 
     tol = 1e-09, ...)

_A_r_g_u_m_e_n_t_s:

     ncp: is the estimated noncentrality parameter, this is generally
          the observed _t_-statistic from comparing the control and
          experimental group (assuming homogeneity of variance)

   smd.c: is the standardized mean difference (using the control group
          standard deviation in the denominator)

     n.C: is the sample size for the control group

     n.E: is the sample size for experimental group

conf.level: is the confidence level (1-Type I error rate)

alpha.lower: is the Type I error rate for the lower tail

alpha.upper: is the Type I error rate for the upper tail

     tol: is the tolerance of the iterative method for determining the
          critical values

     ...: Potentially include parameter for inner functions

_V_a_l_u_e:

Lower.Conf.Limit.smd.c: The lower bound of the computed confidence
          interval

   smd.c: The standardized mean difference based on the control group
          standard deviation

Upper.Conf.Limit.smd.c: The upper bound of the computed confidence
          interval

_W_a_r_n_i_n_g:

     This function uses 'conf.limits.nct', which has as one of its
     arguments 'tol'  (and can be modified with 'tol' of the present
     function).  If the present function fails to converge (i.e., if it
     runs but does not report a solution),  it is likely that the 'tol'
     value is too restrictive and should be increased by a factor of
     10, but probably by no more than 100.  Running the function
     'conf.limits.nct' directly will report the actual probability
     values of the limits found. This should be  done if any
     modification to 'tol' is necessary in order to ensure acceptable
     confidence limits for the noncentral-_t_  parameter have been
     achieved.

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_R_e_f_e_r_e_n_c_e_s:

     Cohen, J. (1988) Statistical power analysis for the behavioral
     sciences (2nd ed.). Hillsdale, NJ: Lawrence Erlbaum.

     Cumming, G. & Finch, S. (2001) A primer on the understanding, use,
     and calculation of confidence intervals that are based on central
     and noncentral distributions, _Educational and Psychological
     Measurement, 61_, 532-574.

     Glass, G. V. (1976) Primary, secondary, and meta-analysis of
     research. _Educational Researcher, 5_, 3-8.

     Hedges, L. V. (1981) Distribution theory for Glass's Estimator of
     effect size and related estimators. _Journal of Educational
     Statistics, 2_, 107-128.

     Kelley, K. (2005) The effects of nonnormal distributions on
     confidence intervals around the standardized mean difference:
     Bootstrap and parametric confidence intervals, _Educational and
     Psychological Measurement, 65_, 51-69.

     Steiger, J. H., & Fouladi, R. T. (1997) Noncentrality interval
     estimation and the evaluation of statistical methods. In L. L.
     Harlow, S. A. Mulaik,&J.H. Steiger (Eds.), _What if there where no
     significance tests?_ (pp. 221-257). Mahwah, NJ: Lawrence Erlbaum.

_S_e_e _A_l_s_o:

     'smd.c', 'smd', 'ci.smd', 'conf.limits.nct'

_E_x_a_m_p_l_e_s:

     ci.smd.c(smd.c=.5, n.C=100, conf.level=.95, n.E=100)

