signal.to.noise.R2           package:MBESS           R Documentation

_S_i_g_n_a_l _t_o _n_o_i_s_e _u_s_i_n_g _s_q_u_a_r_e_d _m_u_l_t_i_p_l_e _c_o_r_r_e_l_a_t_i_o_n _c_o_e_f_f_i_c_i_e_n_t

_D_e_s_c_r_i_p_t_i_o_n:

     Function that calculates five different signal-to-noise ratios
     using the squared multiple correlation coefficient.

_U_s_a_g_e:

     signal.to.noise.R2(R.Square, N, p)

_A_r_g_u_m_e_n_t_s:

R.Square: usual estimate of the squared multiple correlation
          coefficient (with no adjustments)

       N: sample size

       p: number of predictors

_D_e_t_a_i_l_s:

     The method of choice is 'phi2.UMVUE.NL', but it requires 'p' of 5
     or more. In situations where 'p' < 5, it is suggested that
     'phi2.UMVUE.L' be used.

_V_a_l_u_e:

phi2.hat: Basic estimate of the signal-to-noise ratio using the usual
          estimate of the squared multiple correlation coefficient:
          phi2.hat=R2/(1-R2)

phi2.adj.hat: Estimate of the signal-to-noise ratio using the usual
          adjusted R Square in place of R Square: phi2.hat=Adj.R2
          /(1-Adj.R2)

phi2.UMVUE: Muirhead's (1985) unique minimum variance unbiased estimate
          of the signal-to-noise ratio (Muirhead uses theta-U): see
          reference or code for formula

phi2.UMVUE.L: Muirhead's (1985) unique minimum variance unbiased linear
          estimate of the signal-to-noise ratio (Muirhead uses
          theta-L): see reference or code for formula

phi2.UMVUE.NL: Muirhead's (1985) unique minimum variance unbiased
          nonlinear estimate of the signal-to-noise ratio (Muirhead
          uses theta-NL); requires the number of predictors to be
          greater than five: see reference or code for formula

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_R_e_f_e_r_e_n_c_e_s:

     Cohen, J. (1988). Statistical power analysis for the behavioral
     sciences (2nd ed.). Hillsdale, NJ: Lawrence Erlbaum.

     Muirhead, R. J. (1985). Estimating a particular function of the
     multiple correlation coefficient. _Journal of the American
     Statistical Association,  80_, 923-925.

_S_e_e _A_l_s_o:

     'ci.R2', 'ss.aipe.R2'

_E_x_a_m_p_l_e_s:

     signal.to.noise.R2(R.Square=.5, N=50, p=2)
     signal.to.noise.R2(R.Square=.5, N=50, p=5)
     signal.to.noise.R2(R.Square=.5, N=100, p=2)
     signal.to.noise.R2(R.Square=.5, N=100, p=5)

