smd.c                 package:MBESS                 R Documentation

_S_t_a_n_d_a_r_d_i_z_e_d _m_e_a_n _d_i_f_f_e_r_e_n_c_e _u_s_i_n_g _t_h_e _c_o_n_t_r_o_l _g_r_o_u_p _a_s _t_h_e _b_a_s_i_s _o_f 
_s_t_a_n_d_a_r_d_i_z_a_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Function to calculate the standardized mean difference (regular or
     unbiased) using the control group standard deviation  as the basis
     of standardization (for either raw data or summary measures).

_U_s_a_g_e:

     smd.c(Group.T = NULL, Group.C = NULL, Mean.T = NULL, Mean.C = NULL, 
     s.C = NULL, n.C = NULL, Unbiased=FALSE)

_A_r_g_u_m_e_n_t_s:

 Group.T: Raw data for the treatment group.

 Group.C: Raw data for the control group.

  Mean.T: The mean of the treatment group.

  Mean.C: The mean of the control group.

     s.C: The standard deviation of the control group (i.e., the square
          root of the unbiased estimator of the population variance).

     n.C: The sample size of the control group.

Unbiased: Returns the unbiased estimate of the standardized mean
          difference using the standard deviation of the control group.

_D_e_t_a_i_l_s:

     When 'Unbiased=TRUE', the unbiased estimate of the standardized
     mean difference (using the control group as the basis of
     standardization) is returned (Hedges, 1981). Although the unbiased
     estimate of the standardized mean difference is not often
     reported, at least at the present time, it is nevertheless made
     available to those who are interested in calculating this
     quantity.

_V_a_l_u_e:

     Returns the estimated standardized mean difference using the
     control group standard deviation as the basis of standardization.

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_R_e_f_e_r_e_n_c_e_s:

     Hedges, L. V. (1981). Distribution theory for Glass's Estimator of
     effect size and related estimators. _Journal of Educational
     Statistics, 2_, 107-128.

     Glass, G. (1976). Primary, secondary, and meta-analysis of
     research. _Educational Researcher, 5_, 3-8.

_S_e_e _A_l_s_o:

     'smd', 'conf.limits.nct'

_E_x_a_m_p_l_e_s:

     # Generate sample data.
     set.seed(113)
     g.T <- rnorm(n=25, mean=.5, sd=1)
     g.C <- rnorm(n=25, mean=0, sd=1)
     smd.c(Group.T=g.T, Group.C=g.C)

     M.T <- .66745
     M.C <- .24878
     sd.c <- 1.1311
     n.c <- 25
     smd.c(Mean.T=M.T, Mean.C=M.C, s=sd.c)
     smd.c(Mean.T=M.T, Mean.C=M.C, s=sd.c, n.C=n.c, Unbiased=TRUE)

