ss.aipe.R2               package:MBESS               R Documentation

_S_a_m_p_l_e _S_i_z_e _P_l_a_n_n_i_n_g _f_o_r _A_c_c_u_r_a_c_y _i_n _P_a_r_a_m_e_t_e_r _E_s_t_i_m_a_t_i_o_n
_f_o_r _t_h_e _m_u_l_t_i_p_l_e _c_o_r_r_e_l_a_t_i_o_n _c_o_e_f_f_i_c_i_e_n_t.

_D_e_s_c_r_i_p_t_i_o_n:

     Determines necessary sample size for the multiple correlation
     coefficient so that the  confidence interval for the population
     multiple correlation coefficient is  sufficiently narrow.
     Optionally, there is a certainty parameter that allows one to be 
     a specified percent certain that the observed interval will be no
     wider than desired.

_U_s_a_g_e:

     ss.aipe.R2(Population.R2 = NULL, conf.level = 0.95, width = NULL, Random.Predictors = TRUE, 
     Random.Regressors, which.width = "Full", p = NULL, K, degree.of.certainty = NULL, 
     assurance=NULL, certainty=NULL, verify.ss = FALSE, Tol = 1e-09, ...)

_A_r_g_u_m_e_n_t_s:

Population.R2: value of the population multiple correlation coefficient 

conf.level: confidence interval level (e.g., .95, .99, .90); 1-Type I
          error rate 

   width: width of the confidence interval (see 'which.width') 

Random.Predictors: whether or not the predictor variables are random
          (set to TRUE) or are fixed (set to FALSE) 

Random.Regressors: an alias for 'Random.Predictors';
          'Random.Regressors' overrides 'Random.Predictors' 

which.width: defines the width that 'width' refers to 

       p: the number of predictor variables 

       K: an alias for 'p'; 'K' overrides 'p' 

degree.of.certainty: value with which confidence can be placed that
          describes the likelihood of obtaining a confidence interval
          less than the value specified (e.e.g, .80, .90, .95)

assurance: an alias for 'degree.of.certainty' 

certainty: an alias for 'degree.of.certainty'

verify.ss: evaluates numerically via an internal Monte Carlo simulation
          the exact sample size given the specifications

     Tol: the tolerance of the iterative function 'conf.limits.nct' for
          convergence

     ...: for modifying the parameters of functions this function calls
          upon

_D_e_t_a_i_l_s:

     This function determines a necessary sample size so that the
     expected confidence interval width for the squared multiple
     correlation coefficient is sufficiently  narrow (when
     'degree.of.certainty=NULL') or so that the obtained confidence
     interval is no larger than the value specified with some desired
     degree  of certainty (i.e., a probability that the obtained width
     is less than the specified width). The  method depends on whether
     or not the regressors are regarded as fixed or random. This is the
     case because the distribution theory for the two cases is
     different and thus  the confidence interval procedure is
     conditional the type of regressors. The default methods are
     approximate but can be made exact with the specification of
     verify.ss=TRUE, which performs an a priori Monte Carlo simulation
     study .Kelley (2007) and Kelley & Maxwell (In press) detail the 
     methods used in the function, with the former focusing on random
     regressors and the latter  on fixed regressors.

     It is recommended that the option 'verify.ss' should always be
     used! Doing so uses the method impled sample size as an estimate
     and then evaluates with an internal Monte Carlo simulation (i.e.,
     via "brute-force" methods) the exact  sample size given the goals
     specified. When 'verify.ss=TRUE', the default number of iterations
     is 10,000 but this can be changed by specifying G=5000 (or some
     other value; 10000 is the recommended) When 'verify.ss=TRUE' is
     specified, an internal function 'verify.ss.aipe.R2' calls upon the
      'ss.aipe.R2.sensitivity' function for purposes of the internal
     Monte Carlo simulation study. See  the 'verify.ss.aipe.R2'
     function for arguments that can be passed from 'ss.aipe.R2' to 
     'verify.ss.aipe.R2'.

_V_a_l_u_e:

Required.Sample.Size: sample size that should be used given the
          conditions specified.

_N_o_t_e:

     This function without verify.SS=FALSE can be slow to converge when
     'verify.SS=TRUE', the function can take some time to converge
     (e.g., 15 minutes).  Most times this will not be the case, but it
     is possible in some situations.

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_R_e_f_e_r_e_n_c_e_s:

     Algina, J. & Olejnik, S. (2000) Determining sample size for
     accurate estimation of the squared multiple correlation
     coefficient. _Multivariate Behavioral Research, 35_, 119-136.

     Steiger, J. H. & Fouladi, R. T. (1992) R2: {A} computer program
     for interval estimation, power calculation, and hypothesis testing
     for the squared multiple correlation. _Behavior research methods,
     instruments and computers, 4_, 581-582.

     Kelley, K. (2007) Sample size planning for the squared multiple
     correlation coefficient: Accuracy in parameter estimation via
     narrow confidence intervals,  _manuscripted submitted for
     publication_.

     Kelley, K. & Maxwell, S. E. (In press) Power and accuracy for
     omnibus and targeted effects:  Issues of sample size planning with
     applications to multiple regression. In P. Alasuuta, J. Brannen, &
     L. Bickman (Eds.), \textit{Handbook of Social Research Methods}.
     Newbury Park, CA: Sage.

_S_e_e _A_l_s_o:

     'ci.R2', 'conf.limits.nct', 'ss.aipe.R2.sensitivity'

_E_x_a_m_p_l_e_s:

     # Returned sample size should be considered approximate; exact sample
     # size is obtained by specifying the argument 'verify.ss=TRUE' (see below).
     ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     p=5, Random.Predictors=TRUE)
     # Uncomment to run in order to get exact sample size.
     # ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     # p=5, Random.Predictors=TRUE, verify.ss=TRUE)

     # Same as above, except the predictor variables are considered fixed.
     # Returned sample size should be considered approximate; exact sample
     # size is obtained by specifying the argument 'verify.ss=TRUE'.
     ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     p=5, Random.Predictors=FALSE)
     # Uncomment to run in order to get exact sample size.
     #ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     #p=5, Random.Predictors=FALSE, verify.ss=TRUE)

     # Returned sample size should be considered approximate; exact sample
     # size is obtained by specifying the argument 'verify.ss=TRUE'.
     ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     p=5, degree.of.certainty=.85, Random.Predictors=TRUE)
     # Uncomment to run in order to get exact sample size.
     #ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     #p=5, degree.of.certainty=.85, Random.Predictors=TRUE, verify.ss=TRUE)

     # Same as above, except the predictor variables are considered fixed.
     # Returned sample size should be considered approximate; exact sample
     # size is obtained by specifying the argument 'verify.ss=TRUE'.
     ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     p=5, degree.of.certainty=.85, Random.Predictors=FALSE)
     # Uncomment to run in order to get exact sample size.
     #ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
     #p=5, degree.of.certainty=.85, Random.Predictors=FALSE, verify.ss=TRUE)

