ss.aipe.c               package:MBESS               R Documentation

_S_a_m_p_l_e _s_i_z_e _p_l_a_n_n_i_n_g _f_o_r _a_n _A_N_O_V_A _c_o_n_t_r_a_s_t _f_r_o_m _t_h_e _A_c_c_u_r_a_c_y _i_n _P_a_r_a_m_e_t_e_r _E_s_t_i_m_a_t_i_o_n (_A_I_P_E) _p_e_r_s_p_e_c_t_i_v_e

_D_e_s_c_r_i_p_t_i_o_n:

     A function to calculate the appropriate sample size per group for
     the (unstandardized) ANOVA contrast  so that the width of the
     confidence interval is sufficiently narrow.

_U_s_a_g_e:

     ss.aipe.c(error.variance = NULL, c.weights, width, conf.level = 0.95, assurance = NULL, 
     certainty = NULL, MSwithin = NULL, SD = NULL, ...)

_A_r_g_u_m_e_n_t_s:

error.variance: the common error variance; i.e., the mean square error

c.weights: the contrast weights 

   width: the desired full width of the obtained confidence interval 

conf.level: the desired confidence interval coverage, (i.e., 1 - Type I
          error rate)

assurance: parameter to ensure that the obtained confidence interval
          width is narrower than the desired width with a specified
          degree of certainty (must be NULL or between zero and unity) 

certainty: an alias for 'assurance'

MSwithin: an alias for 'error.variance' 

      SD: the standard deviation of the common error in ANOVA model

     ...: allows one to potentially include parameter values for inner
          functions 

_V_a_l_u_e:

       n: the necessary sample size \bf{per group}

_N_o_t_e:

     Be sure to use the error varaince and not its square root (i.e.,
     the standard deviation of the errors).

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu), Keke Lai

_R_e_f_e_r_e_n_c_e_s:

     Kelley, K., Maxwell, S. E., & Rausch, J. R. (2003). Obtaining
     power or obtaining  precesion: Delineating methods of sample size
     planning. _Evaluation and the Health Professions, 26_, 258-287.

     Maxwell, S. E., & Delaney, H. D. (2004). _Designing experiments
     and analyzing data: A model  comparison perspective_. Mahwah, NJ:
     Erlbaum.

_S_e_e _A_l_s_o:

     'ss.aipe.sc', 'ss.aipe.c.ancova', 'ci.c'

_E_x_a_m_p_l_e_s:

     # Suppose the population error variance of some three-group ANOVA model
     # is believed to be 40. The researcher is interested in the difference 
     # between the mean of group 1 and the average of means of group 2 and 3. 
     # To plan the sample size so that, with 90 percent certainty, the 
     # obtained 95 percent full confidence interval width is no wider than 3:

     ss.aipe.c(error.variance=40, c.weights=c(1, -0.5, -0.5), width=3, assurance=.90)

