ss.aipe.sc               package:MBESS               R Documentation

_S_a_m_p_l_e _s_i_z_e _p_l_a_n_n_i_n_g _f_o_r _A_c_c_u_r_a_c_y _i_n _P_a_r_a_m_e_t_e_r _E_s_t_i_m_a_t_i_o_n (_A_I_P_E) _o_f _t_h_e _s_t_a_n_d_a_r_d_i_z_e_d _c_o_n_t_r_a_s_t _i_n _A_N_O_V_A

_D_e_s_c_r_i_p_t_i_o_n:

     A function to calculate the appropriate sample size per group for
     the standardized contrast in ANOVA such that the  width of the
     confidence interval is sufficiently narrow.

_U_s_a_g_e:

     ss.aipe.sc(psi, c.weights, width, conf.level = 0.95, assurance = NULL, certainty = NULL, ...)

_A_r_g_u_m_e_n_t_s:

     psi: population standardized contrast 

c.weights: the contrast weights 

   width: the desired full width of the obtained confidence interval 

conf.level: the desired confidence interval coverage, (i.e., 1 - Type I
          error rate)

assurance: parameter to ensure that the obtained confidence interval
          width is narrower than the desired width with a specified
          degree of certainty (must be NULL or between zero and unity) 

certainty: an alias for 'assurance'

     ...: allows one to potentially include parameter values for inner
          functions 

_V_a_l_u_e:

       n: necessary sample size \bf{per group}

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu), Keke Lai

_R_e_f_e_r_e_n_c_e_s:

     Cumming, G. & Finch, S. (2001) A primer on the understanding, use,
     and calculation of confidence intervals that are based on central
     and noncentral distributions, _Educational and Psychological
     Measurement, 61_, 532-574.

     Hedges, L. V. (1981). Distribution theory for Glass's Estimator of
     effect size and related estimators. _Journal of Educational
     Statistics, 2_, 107-128.

     Kelley, K. (2005) The effects of nonnormal distributions on
     confidence intervals around the standardized mean difference:
     Bootstrap and parametric confidence intervals, _Educational and
     Psychological Measurement, 65_, 51-69.

     Kelley, K. (In press). Constructing confidence intervals for
     standardized effect sizes: Theory, application,  and
     implementation. _Journal of Statistical Software_.

     Kelley, K., & Rausch, J. R. (2006). Sample size planning for the
     standardized mean difference:  Accuracy in Parameter Estimation
     via narrow confidence intervals. _Psychological Methods, 11(4)_,
     363-385.

     Steiger, J. H., & Fouladi, R. T. (1997) Noncentrality interval
     estimation and the evaluation of statistical methods. In L. L.
     Harlow, S. A. Mulaik,&J.H. Steiger (Eds.), _What if there where no
     significance tests?_ (pp. 221-257). Mahwah, NJ: Lawrence Erlbaum.

_S_e_e _A_l_s_o:

     'ci.sc', 'conf.limits.nct', 'ss.aipe.c'

_E_x_a_m_p_l_e_s:

     # Suppose the population standardized contrast is believed to be .6 
     # in some 5-group ANOVA model. The researcher is interested in comparing 
     # the average of means of group 1 and 2 with the average of group 3 and 4.

     # To calculate the necessary sample size per gorup such that the width 
     # of 95 percent confidence interval of the standardized 
     # contrast is, with 90 percent assurance, no wider than .4:

     ss.aipe.sc(psi=.6, c.weights=c(.5, .5, -.5, -.5, 0), width=.4, assurance=.90) 

